export interface Author {
  id: number;
  name: string;
}

export interface Quote {
  id: number;
  text: string;
  author: Author;
}

const backendUrl = `http://localhost:3001`;

export function getRandomQuote(): Promise<Quote> {
  return fetch(backendUrl + "/quotes/random", { credentials: "include" }).then(
    (r) => r.json()
  );
}

export function getQuotesOfAuthor(author: Author): Promise<Quote[]> {
  return fetch(`${backendUrl}/authors/${author.id}/quotes`, {
    credentials: "include",
  }).then((r) => r.json());
}

export function createQuote(text: string, authorName: string): Promise<Quote> {
  return fetch(`${backendUrl}/quotes`, {
    credentials: "include",
    method: "POST",
    headers: {
      "content-type": "application/json",
    },
    body: JSON.stringify({ quote: text, authorName }),
  }).then((r) => r.json());
}

export function checkLogin(): Promise<boolean> {
  return fetch(`${backendUrl}/check-login`, {
    credentials: "include",
  }).then((r) => r.json());
}

export function login(credentials: {
  username: string;
  password: string;
}): Promise<boolean> {
  return fetch(`${backendUrl}/login`, {
    method: "POST",
    body: JSON.stringify(credentials),
    headers: { "content-type": "application/json" },
    credentials: "include",
  }).then((result) => {
    return result.ok;
  });
}

export function logout() {
  return fetch(`${backendUrl}/logout`, {
    method: "POST",
    credentials: "include",
  }).then(() => location.reload());
}
