import { useEffect, useState } from "react";
import { Author, getQuotesOfAuthor, Quote } from "./api";
import "./QuotesOfAuthor.scss";

export function QuotesOfAuthor(props: { author: Author }) {
  const [quotes, setQuotes] = useState<null | Quote[]>(null);
  useEffect(() => {
    getQuotesOfAuthor(props.author).then((quotes) => setQuotes(quotes));
  }, [props.author]);

  return (
    <div className="quotes-of-author">
      <p className="author-name">Weitere Zitate von {props.author.name}</p>
      {quotes ? (
        <ul>
          {quotes.map((quote) => (
            <li key={quote.id}>{quote.text}</li>
          ))}
        </ul>
      ) : (
        <p>Warte auf Daten...</p>
      )}
    </div>
  );
}
