import { FormEvent, useState } from "react";
import { createQuote } from "./api";
import "./NewQuote.scss";

export function NewQuote() {
  const [quote, setQuote] = useState("");
  const [authorName, setAuthorName] = useState("");

  function handleSubmit(e: FormEvent<HTMLFormElement>) {
    e.preventDefault();
    createQuote(quote, authorName);
    setQuote("");
    setAuthorName("");
  }

  return (
    <div className="new-quote">
      <p>Neues Zitat hinzufügen:</p>
      <form onSubmit={handleSubmit}>
        <label htmlFor="quote">Zitat: </label>
        <input
          id="quote"
          type="text"
          value={quote}
          onChange={(e) => setQuote(e.target.value)}
        />

        <label htmlFor="authorName">Autor: </label>
        <input
          id="authorName"
          type="text"
          value={authorName}
          onChange={(e) => setAuthorName(e.target.value)}
        />

        <button type="submit">Speichern</button>
      </form>
    </div>
  );
}
