import { FormEvent, useState } from "react";
import { login } from "./api";
import "./LoginForm.scss";

export function LoginForm(props: { onLogin: () => void }) {
  const [error, setError] = useState(null as string | null);
  const [username, setUsername] = useState("");
  const [password, setPassword] = useState("");

  function handleSubmit(event: FormEvent) {
    event.preventDefault();

    login({ username, password }).then((result) => {
      if (result) props.onLogin();
      else setError("Nutzername oder Passwort inkorrekt");
    });
  }

  return (
    <form className="login-form" onSubmit={handleSubmit}>
      <label htmlFor="username">Nutzername: </label>
      <input
        id="username"
        type="text"
        value={username}
        onChange={(e) => setUsername(e.target.value)}
      />

      <label htmlFor="password">Passwort: </label>
      <input
        id="password"
        type="password"
        value={password}
        onChange={(e) => setPassword(e.target.value)}
      />

      <button type="submit">Login</button>
      {error && <span>{error}</span>}
    </form>
  );
}
