import { useEffect, useState } from "react";
import { checkLogin, getRandomQuote, logout, Quote } from "./api";
import "./App.scss";
import { LoginForm } from "./LoginForm";
import { NewQuote } from "./NewQuote";
import { QuotesOfAuthor } from "./QuotesOfAuthor";

function App() {
  const [randomQuote, setRandomQuote] = useState<Quote | null>(null);
  const [loggedIn, setLoggedIn] = useState(null as boolean | null);

  useEffect(() => {
    checkLogin().then((result) => {
      setLoggedIn(result);
      if (result) reloadQuote();
    });
  }, []);

  function reloadQuote() {
    setRandomQuote(null);
    getRandomQuote().then((quote) => {
      setRandomQuote(quote);
    });
  }

  function handleLogin() {
    setLoggedIn(true);
    reloadQuote();
  }

  return (
    <div className="app">
      {loggedIn && (
        <>
          {randomQuote ? (
            <>
              <button className="logout-button" onClick={logout}>
                Logout
              </button>
              <div className="quote-container">
                <p className="quote">"{randomQuote.text}"</p>
                <p className="author">{randomQuote.author.name}</p>
                <button className="reload-button" onClick={reloadQuote}>
                  Aktualisieren
                </button>
              </div>
            </>
          ) : (
            <div className="quote-container">
              <p className="quote">Warte auf Daten...</p>
            </div>
          )}
          <div className="meta">
            {randomQuote?.author && (
              <QuotesOfAuthor author={randomQuote.author} />
            )}
            <NewQuote />
          </div>
        </>
      )}

      {loggedIn === false && <LoginForm onLogin={handleLogin} />}

      {loggedIn === null && <div>Loading</div>}
    </div>
  );
}

export default App;
