import bodyParser from "body-parser";
import cors from "cors";
import express from "express";
import session from "express-session";
import {
  addQuote,
  getAuthorById,
  getQuotesOfAuthor,
  getRandomQuote,
} from "./db";

const app = express();

app.use(
  cors({
    origin: (origin, callback) => callback(null, origin),
    credentials: true,
  })
);

app.use(
  session({
    secret: "where secret passphrase",
    cookie: { maxAge: 1000 * 60 * 60 * 24 * 14 },
    resave: true,
    saveUninitialized: true,
  })
);

declare module "express-session" {
  interface SessionData {
    loggedIn: boolean | undefined;
  }
}

app.use(bodyParser.json());

app.get("/check-login", (req, res) => {
  const loggedIn = !!req.session.loggedIn;

  res.send(loggedIn);
});

app.post("/login", (req, res) => {
  const { username, password } = req.body;
  if (typeof username !== "string" || typeof password !== "string") {
    res.status(415);
    res.end();
    return;
  }

  if (username !== "admin" || password !== "admin") {
    res.status(401);
    res.end();
    return;
  }

  req.session.loggedIn = true;
  res.status(200);
  res.end();
});

app.post("/logout", (req, res) => {
  req.session.loggedIn = false;
  res.end();
});

app.get("/quotes/random", (req, res) => {
  res.send(getRandomQuote());
});

app.get("/authors/:authorId/quotes", (req, res) => {
  const authorId = parseInt(req.params.authorId);
  if (Number.isNaN(authorId)) {
    res.status(415);
    res.end();
    return;
  }

  const author = getAuthorById(authorId);

  if (!author) {
    res.status(404);
    res.end();
    return;
  }

  res.send(getQuotesOfAuthor(author));
});

app.post("/quotes", (req, res) => {
  const { quote, authorName } = req.body;

  if (!quote || !authorName) {
    res.status(415);
    res.end();
    return;
  }

  const newQuote = addQuote(quote, authorName);

  res.send(newQuote);
});

app.listen(3001);
