import { Injectable } from '@angular/core';
import { delay, Observable, of } from 'rxjs';
import { Author, Quote } from './api.types';

@Injectable({
  providedIn: 'root',
})
export class QuotesService {
  constructor() {}

  getRandomQuote(): Observable<Quote> {
    const id = this.randomId();
    const dummyQuote: Quote = {
      id: id,
      text: `Random Quote ${id}`,
      author: {
        id: 1,
        name: 'Dummy Author',
      },
    };
    return of(dummyQuote).pipe(delay(1000));
  }

  getQuotesOfAuthor(author: Author): Observable<Quote[]> {
    const quotes: Quote[] = [];
    for (let i = 0; i < 5; i++) {
      const id = this.randomId();
      quotes.push({ id, author, text: `Random Quote ${id}` });
    }

    return of(quotes).pipe(delay(1000));
  }

  createQuote(text: string, authorName: string): Observable<Quote> {
    const id = this.randomId();
    const dummyQuote: Quote = {
      id,
      text,
      author: {
        id,
        name: authorName,
      },
    };

    return of(dummyQuote).pipe(delay(1000));
  }

  private randomId() {
    return Math.floor(Math.random() * 9999);
  }
}
