import { HttpClient } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { Author, Quote } from './api.types';

@Injectable({
  providedIn: 'root',
})
export class RealQuotesService {
  backendUrl = 'http://localhost:3001';

  constructor(private client: HttpClient) {}

  getRandomQuote() {
    return this.client.get<Quote>(`${this.backendUrl}/quotes/random`);
  }

  getQuotesOfAuthor(author: Author): Observable<Quote[]> {
    return this.client.get<Quote[]>(
      `${this.backendUrl}/authors/${author.id}/quotes`
    );
  }

  createQuote(text: string, authorName: string): Observable<Quote> {
    return this.client.post<Quote>(`${this.backendUrl}/quotes`, {
      quote: text,
      authorName,
    });
  }
}
