import { Component, Input } from '@angular/core';
import { Author, Quote } from 'src/app/api.types';
import { QuotesService } from 'src/app/quotes.service';

@Component({
  selector: 'app-quotes-of-author',
  templateUrl: './quotes-of-author.component.html',
  styleUrls: ['./quotes-of-author.component.scss'],
})
export class QuotesOfAuthorComponent {
  quotes: Quote[] | null = null;

  _author!: Author;
  @Input() set author(newAuthor: Author) {
    this._author = newAuthor;

    this.quoteService.getQuotesOfAuthor(newAuthor).subscribe((result) => {
      this.quotes = result;
    });
  }

  constructor(private quoteService: QuotesService) {}
}
