import { Component } from '@angular/core';
import { Quote } from 'src/app/api.types';
import { QuotesService } from 'src/app/quotes.service';

@Component({
  selector: 'app-root',
  templateUrl: './app.component.html',
  styleUrls: ['./app.component.scss'],
})
export class AppComponent {
  randomQuote: Quote | null = null;

  constructor(private quoteService: QuotesService) {
    quoteService.getRandomQuote().subscribe((result) => {
      this.randomQuote = result;
    });
  }

  reload() {
    this.randomQuote = null;
    this.quoteService.getRandomQuote().subscribe((result) => {
      this.randomQuote = result;
    });
  }
}
