import { Component } from '@angular/core';
import { FormControl, FormGroup } from '@angular/forms';
import { QuotesService } from 'src/app/quotes.service';

@Component({
  selector: 'app-new-quote',
  templateUrl: './new-quote.component.html',
  styleUrls: ['./new-quote.component.scss'],
})
export class NewQuoteComponent {
  form = new FormGroup({
    quote: new FormControl(''),
    authorName: new FormControl(''),
  });

  constructor(private quoteService: QuotesService) {}

  handleSubmit() {
    this.quoteService
      .createQuote(this.form.value.quote, this.form.value.authorName)
      .subscribe();
    this.form.reset();
  }
}
