import { Component, EventEmitter, Output } from '@angular/core';
import { FormControl, FormGroup } from '@angular/forms';
import { QuotesService } from 'src/app/quotes.service';

@Component({
  selector: 'app-login-form',
  templateUrl: './login-form.component.html',
  styleUrls: ['./login-form.component.scss'],
})
export class LoginFormComponent {
  @Output() login = new EventEmitter<void>();
  error: string | null = null;

  form = new FormGroup({
    username: new FormControl(''),
    password: new FormControl(''),
  });

  constructor(private quoteService: QuotesService) {}

  handleLogin() {
    this.error = null;
    this.quoteService.login(this.form.value).subscribe((result) => {
      if (result) {
        this.login.next();
      } else {
        this.error = 'Nutzername oder Passwort inkorrekt';
      }
    });
  }
}
