import { Component } from '@angular/core';
import { Quote } from 'src/app/api.types';
import { QuotesService } from 'src/app/quotes.service';

@Component({
  selector: 'app-root',
  templateUrl: './app.component.html',
  styleUrls: ['./app.component.scss'],
})
export class AppComponent {
  loggedIn: boolean | null = null;

  randomQuote: Quote | null = null;

  constructor(private quoteService: QuotesService) {
    quoteService.checkLogin().subscribe((loggedIn) => {
      this.loggedIn = loggedIn;
      if (loggedIn) this.reload();
    });
  }

  reload() {
    this.randomQuote = null;
    this.quoteService.getRandomQuote().subscribe((result) => {
      this.randomQuote = result;
    });
  }

  handleLogin() {
    this.loggedIn = true;
    this.reload();
  }

  logout() {
    this.quoteService.logout();
  }
}
